class intersectors extends composition {


  PVector[][] lines = new PVector[0][0];
  PVector[] currentLine;
  segment[][] linesAsSegments = new segment[0][0];
  int polyIntersectCount = 0;
  int singleIntersectCount = 0;
  boolean checkSeparateLines = true;

  intersectors() {
    stroke(255);
  }

  void draw() {
  }

  void mousePressed() {
    lines = (PVector[][]) append(lines, new PVector[0]);
    currentLine = lines[lines.length - 1];
    currentLine = (PVector[]) append(currentLine, new PVector(mouseX, mouseY));
  }

  void mouseReleased() {
    segment[] currentLineSegments = new segment[0];
    for (int currentPoint = currentLine.length-1; currentPoint > 0; currentPoint--) {
      segment seg = new segment(currentLine[currentPoint].x, currentLine[currentPoint].y, currentLine[currentPoint-1].x, currentLine[currentPoint-1].y); 
      currentLineSegments = (segment[]) append(currentLineSegments, seg);
    }
    linesAsSegments = (segment[][]) append(linesAsSegments, currentLineSegments);
    lineLibrary = addLineToLineLibrary(currentLineSegments, lineLibrary);
    // flow
    if (checkSeparateLines) {
      if (polyIntersectingLine()) {
        linesAsSegments = new segment[0][0];
        polyIntersectCount++;
        if(polyIntersectCount == 1) checkSeparateLines = false;
        background(backgroundColor);
      }
    }
    else{
     if(singleIntersectingLine(currentLineSegments, currentLineSegments)){
     singleIntersectCount++;
     if(singleIntersectCount == 1) live_composition = new multiblocks();
     background(backgroundColor);
     }
    }
  }

  void mouseDragged() {
    currentLine = (PVector[]) append(currentLine, new PVector(mouseX, mouseY));
    stroke(255);
    line(pmouseX, pmouseY, mouseX, mouseY);
  }



  boolean polyIntersectingLine() {
    for (segment[] lineToCheck : linesAsSegments) {
      for (segment[] otherLine : linesAsSegments) {
        if (lineToCheck == otherLine) {
        }
        else {
          if (singleIntersectingLine(lineToCheck, otherLine)) return true;
        }
      }
    }
    return false;
  }

  boolean singleIntersectingLine(segment[] lineSegments, segment[] checkedLineSegments) {
    for (segment segToCheck : lineSegments) {
      for (segment otherSeg : checkedLineSegments) {
        if (segToCheck == otherSeg) {
        }
        else if (segToCheck.x1 == otherSeg.x2 && segToCheck.y1 == otherSeg.y2) {
        } 
        else if (segToCheck.x2 == otherSeg.x1 && segToCheck.y2 == otherSeg.y1) {
        }
        else { 
          if (segIntersection(segToCheck, otherSeg) != null) return true;
        }
      }
    }
    return false;
  }

  // from Ryan Alexander
  PVector segIntersection(segment seg1, segment seg2) { 
    float bx = seg1.x2 - seg1.x1; 
    float by = seg1.y2 - seg1.y1; 
    float dx = seg2.x2 - seg2.x1; 
    float dy = seg2.y2 - seg2.y1;
    float b_dot_d_perp = bx * dy - by * dx;
    if (b_dot_d_perp == 0) {
      return null;
    }
    float cx = seg2.x1 - seg1.x1;
    float cy = seg2.y1 - seg1.y1;
    float t = (cx * dy - cy * dx) / b_dot_d_perp;
    if (t < 0 || t > 1) {
      return null;
    }
    float u = (cx * by - cy * bx) / b_dot_d_perp;
    if (u < 0 || u > 1) { 
      return null;
    }
    return new PVector(seg1.x1+t*bx, seg1.y1+t*by);
  }
}

